<?php

namespace Modules\Common\Entities\Entities;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class EntityCategoryType extends Model 
{

    protected $table = 'entity_category_type';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function entity()
    {
        return $this->belongsTo('Modules\Common\Entities\Entities\Entity');
    }

    public function categoryType()
    {
        return $this->belongsTo('Modules\Common\Entities\Entities\CategoryType');
    }

}